#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{

	
	


	[TestFixture]
	public class DAL_BloodUnitMedia : BaseTest 
	{

		private DataTable _dtMedia;

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			if (this.RefreshData)
			{
				this._dtMedia = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM vw_BloodShipAllCurrent WHERE DirectedPatientGuid IS NOT NULL AND BloodUnitGuid IN (SELECT BloodUnitGuid FROM BloodUnit WHERE RecordStatusCode = 'A' AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "')", true);


				//Update the expirationDate so GetDirectedPatients will pass
				int retValue = UnitTestUtil.RunSQL("UPDATE BloodUnitMedia SET UnitExpirationDate = '" + System.DateTime.Now.AddYears(1).ToString() + "' WHERE BloodUnitGuid = '" + this._dtMedia.Rows[0][TABLES.BloodUnitMedia.BloodUnitGuid].ToString() + "'");
				if (retValue == 0)
				{
					throw new Exception("BloodUnitMedia data setup failed.");
				}

				this._dtMedia = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM vw_BloodShipAllCurrent WHERE BloodUnitGuid = '" + this._dtMedia.Rows[0][TABLES.BloodUnitMedia.BloodUnitGuid].ToString() + "'", true);

				this.RefreshData = false;
			}

		}


		[Test]
		public void GetEmptyBloodUnitMediaTableSchema_Pass()
		{
			DataTable dtTest = DAL.BloodUnitMedia.GetEmptyBloodUnitMediaTableSchema(true);
			
			Assert.AreEqual(TABLES.BloodUnitMedia.TableName, dtTest.TableName, "TableName");
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
			Assert.AreEqual(11, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.BloodUnitMediaGuid), TABLES.BloodUnitMedia.BloodUnitMediaGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.TestingStatusId), TABLES.BloodUnitMedia.TestingStatusId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.BloodTypeCode), TABLES.BloodUnitMedia.BloodTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.RhFactorCode), TABLES.BloodUnitMedia.RhFactorCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.UnitExpirationDate), TABLES.BloodUnitMedia.UnitExpirationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.DirectedPatientGuid), TABLES.BloodUnitMedia.DirectedPatientGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DivisionCode), TABLES.BloodUnit.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.Comments), TABLES.BloodUnitMedia.Comments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.RemoveRestrictionTechId), TABLES.BloodUnitMedia.RemoveRestrictionTechId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.RemoveRestrictionDate), TABLES.BloodUnitMedia.RemoveRestrictionDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.RowVersion), TABLES.BloodUnitMedia.RowVersion);
		}

		[Test]
		public void GetEmptyBloodUnitMediaTableSchema_Fail()
		{
			DataTable dtTest = DAL.BloodUnitMedia.GetEmptyBloodUnitMediaTableSchema(false);
			
			Assert.AreEqual(TABLES.BloodUnitMedia.TableName, dtTest.TableName, "TableName");
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
			Assert.AreEqual(9, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.BloodUnitMediaGuid), TABLES.BloodUnitMedia.BloodUnitMediaGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.TestingStatusId), TABLES.BloodUnitMedia.TestingStatusId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.BloodTypeCode), TABLES.BloodUnitMedia.BloodTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.RhFactorCode), TABLES.BloodUnitMedia.RhFactorCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.UnitExpirationDate), TABLES.BloodUnitMedia.UnitExpirationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.DirectedPatientGuid), TABLES.BloodUnitMedia.DirectedPatientGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DivisionCode), TABLES.BloodUnit.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.Comments), TABLES.BloodUnitMedia.Comments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.BloodUnitGuid), TABLES.BloodUnitMedia.BloodUnitGuid);
		}

		[Test]
		public void GetBloodUnitMediaByGuid_Pass()
		{
			System.Guid unitGuid = (System.Guid)this._dtMedia.Rows[0][TABLES.BloodUnitMedia.BloodUnitGuid];

			DataTable dtTest = DAL.BloodUnitMedia.GetBloodUnitMediaByGuid(unitGuid);
			
			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(11, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.BloodUnitMediaGuid), TABLES.BloodUnitMedia.BloodUnitMediaGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.BloodUnitGuid), TABLES.BloodUnitMedia.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.BloodTypeCode), TABLES.BloodUnitMedia.BloodTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.RhFactorCode), TABLES.BloodUnitMedia.RhFactorCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.UnitExpirationDate), TABLES.BloodUnitMedia.UnitExpirationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.TestingStatusId), TABLES.BloodUnitMedia.TestingStatusId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.DirectedPatientGuid), TABLES.BloodUnitMedia.DirectedPatientGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.Comments), TABLES.BloodUnitMedia.Comments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.LastUpdateDate), TABLES.BloodUnitMedia.LastUpdateDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.LastUpdateUser), TABLES.BloodUnitMedia.LastUpdateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.RowVersion), TABLES.BloodUnitMedia.RowVersion);

			Assert.AreEqual(unitGuid.ToString(), dtTest.Rows[0][TABLES.BloodUnitMedia.BloodUnitGuid].ToString(), "BloodUnitGuid");
		}

		[Test]
		public void GetBloodUnitMediaByGuid_Fail()
		{
			DataTable dtTest = DAL.BloodUnitMedia.GetBloodUnitMediaByGuid(System.Guid.NewGuid());

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetBloodUnitsByPatient_Guid_Pass()
		{

			System.Guid patientGuid = DataCreator.GetRecordGuid("SELECT DirectedPatientGuid FROM vw_BloodShipPatientAllCurrent WHERE DirectedPatientGuid IS NOT NULL AND UnitExpirationDate > GETUTCDATE() AND UnitStatusCode IN ('A','C','L','S') AND DivisionCode = '" + this.TestDivisionCode + "'");

			DataTable dtTest = DAL.BloodUnitMedia.GetBloodUnitsByPatient(patientGuid);

			Assert.AreEqual(43, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.EyeReadableUnitId), TABLES.BloodUnit.EyeReadableUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitProductCode), TABLES.BloodUnit.UnitProductCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DonationTypeId), TABLES.BloodUnit.DonationTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.DonationType.DonationTypeText), TABLES.DonationType.DonationTypeText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelTypeCode), TABLES.BloodUnit.LabelTypeCode);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodUnitGuid), TABLES.BloodUnit.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.RhFactorCode), TABLES.BloodUnitMedia.RhFactorCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.UnitExpirationDate), TABLES.BloodUnitMedia.UnitExpirationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClass.ComponentClassId), TABLES.ComponentClass.ComponentClassId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitInDate), TABLES.BloodUnit.UnitInDate);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DivisionCode), TABLES.BloodUnit.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.BloodTypeCode), TABLES.BloodUnitMedia.BloodTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitFdaRegistrationNumber), TABLES.BloodUnit.UnitFdaRegistrationNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelUnitId), TABLES.BloodUnit.LabelUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductTypeCode), TABLES.BloodProduct.ProductTypeCode);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductName), TABLES.BloodProduct.ProductName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductShortName), TABLES.BloodProduct.ProductShortName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductType.ProductTypeName), TABLES.ProductType.ProductTypeName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RhFactor.RhFactorText), TABLES.RhFactor.RhFactorText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Facility.FacilityName), TABLES.Facility.FacilityName);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodProductGuid), TABLES.BloodUnit.BloodProductGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientFirstName), TABLES.Patient.PatientFirstName);			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientMiddleName), TABLES.Patient.PatientMiddleName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientLastName), TABLES.Patient.PatientLastName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.MaximumStorageTime), TABLES.BloodProduct.MaximumStorageTime);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.VistaPatientId), TABLES.Patient.VistaPatientId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientSsn), TABLES.Patient.PatientSsn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.DisplayVistaPatientId), TABLES.Patient.DisplayVistaPatientId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.UnitStatusComments), TABLES.BloodUnitStatus.UnitStatusComments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.DiscardCannedCommentGuid), TABLES.BloodUnitStatus.DiscardCannedCommentGuid);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode), TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.UnitStatus.UnitStatusText), TABLES.UnitStatus.UnitStatusText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.QuarantineIndicator), TABLES.BloodUnitStatus.QuarantineIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.TestingStatusId), TABLES.BloodUnitMedia.TestingStatusId);			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.OriginalVolume), TABLES.BloodUnit.OriginalVolume);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitShipment.IncomingShipmentGuid), TABLES.BloodUnitShipment.IncomingShipmentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.RowVersion), TABLES.BloodUnit.RowVersion);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.Comments), TABLES.BloodUnitMedia.Comments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitDivisionId), TABLES.BloodUnit.UnitDivisionId);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.ABORh), ARTIFICIAL.ABORh); 
	
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Shipment.ShipmentDate), TABLES.Shipment.ShipmentDate);			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.PresumedTransfusedIndicator), TABLES.BloodUnitStatus.PresumedTransfusedIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.BloodUnitStatusGuid), TABLES.BloodUnitStatus.BloodUnitStatusGuid);
		}

		[Test]
		public void GetBloodUnitsByPatient_Guid_Fail()
		{
			DataTable dtTest = DAL.BloodUnitMedia.GetBloodUnitsByPatient(System.Guid.NewGuid());

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetBloodUnitsByPatient_Guid_Int_Pass()
		{
			int componentId = (int)this._dtMedia.Rows[0][TABLES.ComponentClass.ComponentClassId];
			System.Guid patientGuid = (System.Guid)this._dtMedia.Rows[0][TABLES.BloodUnitMedia.DirectedPatientGuid];

			DataTable dtTest = DAL.BloodUnitMedia.GetBloodUnitsByPatient(patientGuid,componentId);

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(41, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.EyeReadableUnitId), TABLES.BloodUnit.EyeReadableUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitProductCode), TABLES.BloodUnit.UnitProductCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DonationTypeId), TABLES.BloodUnit.DonationTypeId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.DonationType.DonationTypeText), TABLES.DonationType.DonationTypeText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodProductGuid), TABLES.BloodUnit.BloodProductGuid);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.BloodUnitGuid), TABLES.BloodUnit.BloodUnitGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.RhFactorCode), TABLES.BloodUnitMedia.RhFactorCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.UnitExpirationDate), TABLES.BloodUnitMedia.UnitExpirationDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClass.ComponentClassId), TABLES.ComponentClass.ComponentClassId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitInDate), TABLES.BloodUnit.UnitInDate);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.DivisionCode), TABLES.BloodUnit.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.BloodTypeCode), TABLES.BloodUnitMedia.BloodTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.UnitFdaRegistrationNumber), TABLES.BloodUnit.UnitFdaRegistrationNumber);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelUnitId), TABLES.BloodUnit.LabelUnitId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductTypeCode), TABLES.BloodProduct.ProductTypeCode);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductName), TABLES.BloodProduct.ProductName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductShortName), TABLES.BloodProduct.ProductShortName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ProductType.ProductTypeName), TABLES.ProductType.ProductTypeName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.RhFactor.RhFactorText), TABLES.RhFactor.RhFactorText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Facility.FacilityName), TABLES.Facility.FacilityName);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientFirstName), TABLES.Patient.PatientFirstName);			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientMiddleName), TABLES.Patient.PatientMiddleName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientLastName), TABLES.Patient.PatientLastName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.MaximumStorageTime), TABLES.BloodProduct.MaximumStorageTime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.VistaPatientId), TABLES.Patient.VistaPatientId);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientSsn), TABLES.Patient.PatientSsn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.DisplayVistaPatientId), TABLES.Patient.DisplayVistaPatientId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.UnitStatusComments), TABLES.BloodUnitStatus.UnitStatusComments);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.DiscardCannedCommentGuid), TABLES.BloodUnitStatus.DiscardCannedCommentGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode), TABLES.BloodUnitStatusCodeCurrent.UnitStatusCode);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.UnitStatus.UnitStatusText), TABLES.UnitStatus.UnitStatusText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.QuarantineIndicator), TABLES.BloodUnitStatus.QuarantineIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.TestingStatusId), TABLES.BloodUnitMedia.TestingStatusId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.OriginalVolume), TABLES.BloodUnit.OriginalVolume);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.RowVersion), TABLES.BloodUnit.RowVersion);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitMedia.Comments), TABLES.BloodUnitMedia.Comments);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.ABORh), ARTIFICIAL.ABORh); 
			Assert.AreEqual(true , dtTest.Columns.Contains(TABLES.BloodUnitShipment.IncomingShipmentGuid), TABLES.BloodUnitShipment.IncomingShipmentGuid);			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.LabelTypeCode), TABLES.BloodUnit.LabelTypeCode);
			Assert.AreEqual(true , dtTest.Columns.Contains(TABLES.Shipment.ShipmentDate), TABLES.Shipment.ShipmentDate);			

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnitStatus.PresumedTransfusedIndicator), TABLES.BloodUnitStatus.PresumedTransfusedIndicator);
		}

		[Test]
		public void GetBloodUnitsByPatient_Guid_Int_Fail()
		{
			DataTable dtTest = DAL.BloodUnitMedia.GetBloodUnitsByPatient(System.Guid.NewGuid(), 0);

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void Save_Pass()
		{
			this.RefreshData = true;

			DataTable dtBUM = DAL.BloodUnitMedia.GetEmptyBloodUnitMediaTableSchema(true);
			BOL.BloodUnitMedia tmpMedia = new BOL.BloodUnitMedia((System.Guid)this._dtMedia.Rows[0][TABLES.BloodUnitMedia.BloodUnitGuid]);

			dtBUM.Rows.Add(tmpMedia.LoadDataRowFromThis(dtBUM.NewRow()));

			Common.Utility.AppendLastUpdateInformation(dtBUM, Common.UpdateFunction.UnitTests);
			
			dtBUM.Rows[0][TABLES.BloodUnitMedia.Comments] = "UnitTested: " + System.DateTime.Now.ToString();
			bool retValue = DAL.BloodUnitMedia.Save(dtBUM.Rows[0]);

			Assert.AreEqual(true, retValue, "RetunValue");
		}

		[Test]
		[ExpectedException(typeof(Common.RowVersionException))]
		public void Save_Fail()
		{
			this.RefreshData = true;

			DataTable dtBUM = DAL.BloodUnitMedia.GetEmptyBloodUnitMediaTableSchema(true);
			BOL.BloodUnitMedia tmpMedia = new BOL.BloodUnitMedia((System.Guid)this._dtMedia.Rows[0][TABLES.BloodUnitMedia.BloodUnitGuid]);

			dtBUM.Rows.Add(tmpMedia.LoadDataRowFromThis(dtBUM.NewRow()));

			Common.Utility.AppendLastUpdateInformation(dtBUM, Common.UpdateFunction.UnitTests);
			
			dtBUM.Rows[0][TABLES.BloodUnitMedia.Comments] = "UnitTested: " + System.DateTime.Now.ToString();
			dtBUM.Rows[0][TABLES.BloodUnitMedia.RowVersion] = new byte[8];

			DAL.BloodUnitMedia.Save(dtBUM.Rows[0]);
		}
		
		[Test]
		public void ReleaseRestriction_Pass()
		{
			this.RefreshData = true;

			DataTable dtData = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodUnitMedia WHERE DirectedPatientGuid IS NOT NULL");
			System.Guid bumGuid = (System.Guid) dtData.Rows[0][TABLES.BloodUnitMedia.BloodUnitMediaGuid];

			DataTable dtBloodUnitMedia = new DataTable(TABLES.BloodUnitMedia.TableName);
			dtBloodUnitMedia.Columns.Add(TABLES.BloodUnitMedia.BloodUnitMediaGuid, typeof(System.Guid));
			dtBloodUnitMedia.Columns.Add(TABLES.BloodUnitMedia.RemoveRestrictionTechId, typeof(string));
			dtBloodUnitMedia.Columns.Add(TABLES.BloodUnitMedia.RemoveRestrictionDate, typeof(System.DateTime));
			dtBloodUnitMedia.Columns.Add(TABLES.BloodUnitMedia.Comments, typeof(string));
			dtBloodUnitMedia.Columns.Add(TABLES.OrderedUnit.DivisionCode, typeof(string));
			dtBloodUnitMedia.Columns.Add(TABLES.BloodUnitMedia.LastUpdateUser, typeof(string));
			dtBloodUnitMedia.Columns.Add(TABLES.BloodUnitMedia.RowVersion, typeof(byte[]));
	
			DataRow drBloodUnitMedia = dtBloodUnitMedia.NewRow();
			drBloodUnitMedia[TABLES.BloodUnitMedia.BloodUnitMediaGuid] = bumGuid;
			drBloodUnitMedia[TABLES.BloodUnitMedia.RemoveRestrictionDate] = System.DateTime.Now;
			drBloodUnitMedia[TABLES.BloodUnitMedia.RemoveRestrictionTechId] = "carrie";
			drBloodUnitMedia[TABLES.BloodUnitMedia.Comments] = "Releasing restriction for unit tests.";
			drBloodUnitMedia[TABLES.OrderedUnit.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
			drBloodUnitMedia[TABLES.BloodUnitMedia.LastUpdateUser] = Common.LogonUser.LogonUserName;
			drBloodUnitMedia[TABLES.BloodUnitMedia.RowVersion] = dtData.Rows[0][TABLES.BloodUnitMedia.RowVersion];
			dtBloodUnitMedia.Rows.Add( drBloodUnitMedia );



			bool retValue = DAL.BloodUnitMedia.ReleaseRestriction(dtBloodUnitMedia, Common.UpdateFunction.UnitTests);

			DataTable dtSavedData = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodUnitMedia WHERE BloodUnitMediaGuid = '" + bumGuid.ToString() + "'");
			
			//Now just verify that the directed patient guid is null
			Assert.AreEqual(true, retValue, "RetunValue");
			Assert.AreEqual(dtSavedData.Rows[0][TABLES.BloodUnitMedia.DirectedPatientGuid], DBNull.Value, "Null Check");

		}

		[Test]
		[ExpectedException(typeof(gov.va.med.vbecs.Common.DataAccessLayerException))]
		public void ReleaseRestriction_Fail()
		{
			DataTable dtData = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodUnitMedia WHERE DirectedPatientGuid IS NOT NULL");
			System.Guid bumGuid = (System.Guid) dtData.Rows[0][TABLES.BloodUnitMedia.BloodUnitMediaGuid];

			DataTable dtBloodUnitMedia = new DataTable(TABLES.BloodUnitMedia.TableName);
			dtBloodUnitMedia.Columns.Add(TABLES.BloodUnitMedia.BloodUnitMediaGuid, typeof(System.Guid));
			dtBloodUnitMedia.Columns.Add(TABLES.BloodUnitMedia.RemoveRestrictionTechId, typeof(string));
			dtBloodUnitMedia.Columns.Add(TABLES.BloodUnitMedia.RemoveRestrictionDate, typeof(System.DateTime));
			dtBloodUnitMedia.Columns.Add(TABLES.BloodUnitMedia.Comments, typeof(string));
			dtBloodUnitMedia.Columns.Add(TABLES.OrderedUnit.DivisionCode, typeof(string));
			dtBloodUnitMedia.Columns.Add(TABLES.BloodUnitMedia.LastUpdateUser, typeof(string));
			dtBloodUnitMedia.Columns.Add(TABLES.BloodUnitMedia.RowVersion, typeof(byte[]));
	
			DataRow drBloodUnitMedia = dtBloodUnitMedia.NewRow();
			drBloodUnitMedia[TABLES.BloodUnitMedia.BloodUnitMediaGuid] = bumGuid;
			drBloodUnitMedia[TABLES.BloodUnitMedia.RemoveRestrictionDate] = System.DateTime.Now;
			drBloodUnitMedia[TABLES.BloodUnitMedia.RemoveRestrictionTechId] = "carrie";
			drBloodUnitMedia[TABLES.BloodUnitMedia.Comments] = "Releasing restriction for unit tests.";
			drBloodUnitMedia[TABLES.OrderedUnit.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
			drBloodUnitMedia[TABLES.BloodUnitMedia.LastUpdateUser] = Common.LogonUser.LogonUserName;
			drBloodUnitMedia[TABLES.BloodUnitMedia.RowVersion] = new byte[8];
			dtBloodUnitMedia.Rows.Add( drBloodUnitMedia );

			bool retValue = DAL.BloodUnitMedia.ReleaseRestriction(dtData, Common.UpdateFunction.UnitTests);
			
		}
		[Test]
		public void GetBloodUnitMediaDirectedPatientByGuid_Pass()
		{
			this.RefreshData = true;

			DataTable dtData = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodUnitMedia WHERE DirectedPatientGuid IS NOT NULL");
			System.Guid bumGuid = (System.Guid) dtData.Rows[0][TABLES.BloodUnitMedia.BloodUnitMediaGuid];
			System.Guid buGuid = (System.Guid) dtData.Rows[0][TABLES.BloodUnitMedia.BloodUnitGuid];
			System.Guid directedPatientGuid = (System.Guid) dtData.Rows[0][TABLES.BloodUnitMedia.DirectedPatientGuid];

			DataTable dtBloodUnitMedia = new DataTable(TABLES.BloodUnitMedia.TableName);
			dtBloodUnitMedia.Columns.Add(TABLES.BloodUnitMedia.BloodUnitMediaGuid, typeof(System.Guid));
			dtBloodUnitMedia.Columns.Add(TABLES.BloodUnitMedia.RemoveRestrictionTechId, typeof(string));
			dtBloodUnitMedia.Columns.Add(TABLES.BloodUnitMedia.RemoveRestrictionDate, typeof(System.DateTime));
			dtBloodUnitMedia.Columns.Add(TABLES.BloodUnitMedia.Comments, typeof(string));
			dtBloodUnitMedia.Columns.Add(TABLES.OrderedUnit.DivisionCode, typeof(string));
			dtBloodUnitMedia.Columns.Add(TABLES.BloodUnitMedia.LastUpdateUser, typeof(string));
			dtBloodUnitMedia.Columns.Add(TABLES.BloodUnitMedia.RowVersion, typeof(byte[]));
	
			DataRow drBloodUnitMedia = dtBloodUnitMedia.NewRow();
			drBloodUnitMedia[TABLES.BloodUnitMedia.BloodUnitMediaGuid] = bumGuid;
			drBloodUnitMedia[TABLES.BloodUnitMedia.RemoveRestrictionDate] = System.DateTime.Now;
			drBloodUnitMedia[TABLES.BloodUnitMedia.RemoveRestrictionTechId] = "carrie";
			drBloodUnitMedia[TABLES.BloodUnitMedia.Comments] = "Releasing restriction for unit tests.";
			drBloodUnitMedia[TABLES.OrderedUnit.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
			drBloodUnitMedia[TABLES.BloodUnitMedia.LastUpdateUser] = Common.LogonUser.LogonUserName;
			drBloodUnitMedia[TABLES.BloodUnitMedia.RowVersion] = dtData.Rows[0][TABLES.BloodUnitMedia.RowVersion];
			dtBloodUnitMedia.Rows.Add( drBloodUnitMedia );

			bool retValue = DAL.BloodUnitMedia.ReleaseRestriction(dtBloodUnitMedia, Common.UpdateFunction.UnitTests);

			System.Data.DataTable dt = DAL.BloodUnitMedia.GetBloodUnitMediaDirectedPatientByGuid(buGuid);
			Assert.AreEqual(dt.Rows[0][TABLES.BloodUnitMedia.DirectedPatientGuid], directedPatientGuid, "Equal Check");
		}

		[Test]
		public void GetBloodUnitMediaDirectedPatientByGuid_Fail()
		{
			System.Data.DataTable dt = DAL.BloodUnitMedia.GetBloodUnitMediaDirectedPatientByGuid(System.Guid.NewGuid());

			Assert.AreEqual(0, dt.Rows.Count, "Rows.Count");
		}
	}
}
#endif
